
(function (root, factory) {

    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    };

    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    echarts.registerTheme('vintage', {
        "color": [
            "#2060e4",
            "#0c3d99",
            "#147eb7",
            "#2727e8",
            "#119c6d",
            "#cda431",
            "#9ab11c",
            "#13ce46",
            "#2e9583",
            "#11d9f5"
        ],
        "backgroundColor": "rgba(4,40,98,0.9)",
        "textStyle": {},
        "title": {
            "textStyle": {
                "color": "#ffffff"
            },
            "subtextStyle": {
                "color": "#e3da14"
            }
        },
        "line": {
            "itemStyle": {
                "borderWidth": 1
            },
            "lineStyle": {
                "width": "1"
            },
            "symbolSize": "2",
            "symbol": "emptyCircle",
            "smooth": true
        },
        "radar": {
            "itemStyle": {
                "borderWidth": 1
            },
            "lineStyle": {
                "width": "1"
            },
            "symbolSize": "2",
            "symbol": "emptyCircle",
            "smooth": true
        },
        "bar": {
            "itemStyle": {
                "barBorderWidth": 0,
                "barBorderColor": "#ffffff"
            }
        },
        "pie": {
            "itemStyle": {
                "borderRadius": 10,
                "borderWidth": 0,
                "borderColor": "#fff"
            },
            label: {
                color: '#ffffff'
            }
        },
        "scatter":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "boxplot":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "parallel":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "sankey":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "funnel":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "gauge":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
            }
        ,
        "candlestick":
            {
                "itemStyle":
                    {
                        "color":
                            "#c23531",
                        "color0":
                            "#314656",
                        "borderColor":
                            "#c23531",
                        "borderColor0":
                            "#314656",
                        "borderWidth":
                            1
                    }
            }
        ,
        "graph":
            {
                "itemStyle":
                    {
                        "borderWidth":
                            0,
                        "borderColor":
                            "#cccccc"
                    }
                ,
                "lineStyle":
                    {
                        "width":
                            1,
                        "color":
                            "#aaaaaa"
                    }
                ,
                "symbolSize":
                    "2",
                "symbol":
                    "emptyCircle",
                "smooth":
                    true,
                "color":
                    [
                        "#2060e4",
                        "#0c3d99",
                        "#147eb7",
                        "#2727e8",
                        "#119c6d",
                        "#cda431",
                        "#9ab11c",
                        "#13ce46",
                        "#2e9583",
                        "#11d9f5"
                    ],
                "label":
                    {
                        "color":
                            "#473942"
                    }
            }
        ,
        "map":
            {
                "itemStyle":
                    {
                        "areaColor":
                            "#eeeeee",
                        "borderColor":
                            "#444444",
                        "borderWidth":
                            0.5
                    }
                ,
                "label":
                    {
                        "color":
                            "#000000"
                    }
                ,
                "emphasis":
                    {
                        "itemStyle":
                            {
                                "areaColor":
                                    "rgba(255,215,0,0.8)",
                                "borderColor":
                                    "#444444",
                                "borderWidth":
                                    1
                            }
                        ,
                        "label":
                            {
                                "color":
                                    "rgb(100,0,0)"
                            }
                    }
            }
        ,
        "geo":
            {
                "itemStyle":
                    {
                        "areaColor":
                            "#eeeeee",
                        "borderColor":
                            "#444444",
                        "borderWidth":
                            0.5
                    }
                ,
                "label":
                    {
                        "color":
                            "#000000"
                    }
                ,
                "emphasis":
                    {
                        "itemStyle":
                            {
                                "areaColor":
                                    "rgba(255,215,0,0.8)",
                                "borderColor":
                                    "#444444",
                                "borderWidth":
                                    1
                            }
                        ,
                        "label":
                            {
                                "color":
                                    "rgb(100,0,0)"
                            }
                    }
            }
        ,
        "categoryAxis":
            {
                "axisLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#14589F"
                            }
                    }
                ,
                "axisTick":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#14589F"
                            }
                    }
                ,
                "axisLabel":
                    {
                        "show":
                            true,
                        "color":
                            "#ffffff"
                    }
                ,
                "splitLine":
                    {
                        "show":
                            false,
                        "lineStyle":
                            {
                                "color":
                                    [
                                        "#ccc"
                                    ]
                            }
                    }
                ,
                "splitArea":
                    {
                        "show":
                            false,
                        "areaStyle":
                            {
                                "color":
                                    [
                                        "rgba(250,250,250,0.3)",
                                        "rgba(200,200,200,0.3)"
                                    ]
                            }
                    }
            }
        ,
        "valueAxis":
            {
                "axisLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#14589F"
                            }
                    }
                ,
                "axisTick":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#14589F"
                            }
                    }
                ,
                "axisLabel":
                    {
                        "show":
                            true,
                        "color":
                            "#ffffff"
                    }
                ,
                "splitLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    [
                                        "#14589F"
                                    ]
                            }
                    }
                ,
                "splitArea":
                    {
                        "show":
                            false,
                        "areaStyle":
                            {
                                "color":
                                    [
                                        "rgba(250,250,250,0.3)",
                                        "rgba(200,200,200,0.3)"
                                    ]
                            }
                    }
            }
        ,
        "logAxis":
            {
                "axisLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#2060e4"
                            }
                    }
                ,
                "axisTick":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    "#2060e4"
                            }
                    }
                ,
                "axisLabel":
                    {
                        "show":
                            true,
                        "color":
                            "#8b1414"
                    }
                ,
                "splitLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    [
                                        "#ccc"
                                    ]
                            }
                    }
                ,
                "splitArea":
                    {
                        "show":
                            false,
                        "areaStyle":
                            {
                                "color":
                                    [
                                        "rgba(250,250,250,0.3)",
                                        "rgba(200,200,200,0.3)"
                                    ]
                            }
                    }
            }
        ,
        "timeAxis":
            {
                "axisLine":
                    {
                        "show":
                            true,
                        "color":
                            "#14589F"
                    }
                ,
                "axisTick":
                    {
                        "show":
                            true,
                        "color":
                            "#14589F"
                    }
                ,
                "axisLabel":
                    {
                        "show":
                            true,
                        "color":
                            "#ffffff"
                    }
                ,
                "splitLine":
                    {
                        "show":
                            true,
                        "lineStyle":
                            {
                                "color":
                                    [
                                        "#14589F"
                                    ]
                            }
                    }
                ,
                "splitArea":
                    {
                        "show":
                            false,
                        "areaStyle":
                            {
                                "color":
                                    [
                                        "rgba(250,250,250,0.3)",
                                        "rgba(200,200,200,0.3)"
                                    ]
                            }
                    }
            }
        ,
        "toolbox":
            {
                "iconStyle":
                    {
                        "borderColor":
                            "#999999"
                    }
                ,
                "emphasis":
                    {
                        "iconStyle":
                            {
                                "borderColor":
                                    "#666666"
                            }
                    }
            }
        ,
        "legend":
            {
                "textStyle":
                    {
                        "color":
                            "#ffffff"
                    }
                ,
                "orient":
                    "vertical",
                "left":
                    "right"
            }
        ,
        "tooltip":
            {
                "axisPointer":
                    {
                        "lineStyle":
                            {
                                "color":
                                    "#cccccc",
                                "width":
                                    1
                            }
                        ,
                        "crossStyle":
                            {
                                "color":
                                    "#cccccc",
                                "width":
                                    1
                            }
                    }
            }
        ,
        "timeline":
            {
                "lineStyle":
                    {
                        "color":
                            "#293c55",
                        "width":
                            "1"
                    }
                ,
                "itemStyle":
                    {
                        "color":
                            "#293c55",
                        "borderWidth":
                            1
                    }
                ,
                "controlStyle":
                    {
                        "color":
                            "#293c55",
                        "borderColor":
                            "#293c55",
                        "borderWidth":
                            0.5
                    }
                ,
                "checkpointStyle":
                    {
                        "color":
                            "#e43c59",
                        "borderColor":
                            "#c23531"
                    }
                ,
                "label":
                    {
                        "color":
                            "#293c55"
                    }
                ,
                "emphasis":
                    {
                        "itemStyle":
                            {
                                "color":
                                    "#a9334c"
                            }
                        ,
                        "controlStyle":
                            {
                                "color":
                                    "#293c55",
                                "borderColor":
                                    "#293c55",
                                "borderWidth":
                                    0.5
                            }
                        ,
                        "label":
                            {
                                "color":
                                    "#293c55"
                            }
                    }
            }
        ,
        "visualMap":
            {
                "color":
                    [
                        "#bf444c",
                        "#d88273",
                        "#f6efa6"
                    ]
            }
        ,
        "dataZoom":
            {
                "backgroundColor":
                    "rgba(47,69,84,0)",
                "dataBackgroundColor":
                    "rgba(47,69,84,0.3)",
                "fillerColor":
                    "rgba(167,183,204,0.4)",
                "handleColor":
                    "#a7b7cc",
                "handleSize":
                    "100%",
                "textStyle":
                    {
                        "color":
                            "#333333"
                    }
            }
        ,
        "markPoint":
            {
                "label":
                    {
                        "color":
                            "#473942"
                    }
                ,
                "emphasis":
                    {
                        "label":
                            {
                                "color":
                                    "#473942"
                            }
                    }
            }
    })
    ;
}));
